<?php
namespace model;

class Message extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'type'		=>	'ENUM("inbox", "outbox")',
				'user_id'	=>	'INT UNSIGNED',
				'target_id'	=>	'INT UNSIGNED',
				'message'	=>	'TEXT'
			))
		);
	}
	
	// Validation
	public function columns($preset)
	{
		return array
		(
			'target_id'	=>	array('text', array('c_message_self'=>array($this, 'message_self'), 'c_user_exists'=>array($this, 'user_exists'))),
			'message'	=>	array('textarea', array('optional'=>false))
		);
	}
	
	public function message_self($name)
	{
		return strtolower(\lib\Session::user()->username) != strtolower($name);
	}
	
	public function user_exists($name)
	{
		return \model\User::num_rows('WHERE username=?', $name)?true:false;
	}
	
	public function fields($action, $fields, $form)
	{
		return array
		(
			'type'		=>	'outbox',
			'user_id'	=>	\model\User::get('WHERE username=?', $fields['target_id'])->fetch()->id,
			'target_id'	=>	\lib\Session::user()->id,
			'message'	=>	$fields['message']
		);
	}
	
	// Create
	public function create($name='instance', $preset='default')
	{
		$form = parent::create($name, $preset);
		
		if($form->valid)
		{
			$this->user->unread++;
			
			\lib\db::query('INSERT INTO '.static::table_name().' (trash, ts_edit, ts_create, type, user_id, target_id, message) VALUES (0, ?, ?, "inbox", ?, ?, ?)', array(time(), time(), $this->target_id, $this->user_id, $this->message));
		}
		
		return $form;
	}
}